import { IMAGES_URL } from '@/constants';

const ServiceBanner: React.FC<{ pageInfo: any }> = ({ pageInfo }) => {
  const { attributes } = pageInfo;
  const images = attributes.imagen.data;

  if (!images || images.length < 3) {
    return null;
  }

  return (
    <div className="relative flex mb-[30px] mt-[80px] items-center justify-center bg-black md:mt-[30px] xl:mt-[5px]">
      <div className="relative ml-[20px] mr-[20px] md:ml-[190px] md:mr-[190px]">

        {/* Imagen 1 */}
        <div className="absolute top-[-29%] left-[8%] w-[42vw] h-[42vw] md:w-[300px] md:h-[300px] xl:top-[-29%] xl:left-[8.2%] xl:w-[34.5vw] xl:h-[34.5vw] 2xl:top-[-31%] 2xl:w-[38vw] 2xl:h-[38vw] 2xl:left-[7.5%] z-[10]">
          <div
            className="relative w-full h-full bg-cover bg-center rounded-full"
            style={{ backgroundImage: `url(${IMAGES_URL + images[1].attributes.url})` }}
          ></div>
        </div>

        {/* Imagen 2 */}
        <div className="absolute top-[19%] left-[67%] w-[26vw] h-[26vw] md:left-[436px] md:top-[20%] md:w-[180px] md:h-[180px] xl:left-[67.6%] xl:top-[20%] xl:h-[20.5vw] xl:w-[20.5vw] 2xl:top-[19.8%] 2xl:w-[22.5vw] 2xl:h-[22.5vw] 2xl:left-[67.5%] z-[10]">
          <div
            className="relative w-full h-full bg-cover bg-center rounded-full"
            style={{ backgroundImage: `url(${IMAGES_URL + images[2].attributes.url})` }}
          ></div>
        </div>

        {/* Marco */}
        <img src={IMAGES_URL + images[0].attributes.url} alt="Marco" className="w-full h-full object-cover z-[50] relative" />

      </div>
    </div>
  );
};

export default ServiceBanner;


