import { useState, useEffect } from 'react';
import Circles from './Circles';
import ProgressBar from './ProgressBar';
import NavigationDots from './NavigationDots';
import { IMAGES_URL } from '@/constants';

const InteractiveComponent: React.FC<{ attributes: any }> = ({ attributes }) => {
  const [currentIndex, setCurrentIndex] = useState<number>(0);
  const circlesNosotros = attributes.Circle_Nosotros || [];

  // Agregamos un título vacío al inicio del array
  const titles = ['', ...circlesNosotros.map((circle: any) => circle.title)];

  // Mapear los textos (aunque no lo estás utilizando aquí)
  const texts = circlesNosotros.map((circle: any) => circle.text);
  
  // Agregar la imagen de 'public' como primer elemento del array de imágenes
  const images = [
    './Valores.svg',  // Imagen de 'public'
    ...circlesNosotros.map((circle: any) => IMAGES_URL + circle.Values_image.data.attributes.url)
  ];

  const progressBarWidth = `${(currentIndex + 1) / titles.length * 100}%`;
  const imageSource = images[currentIndex % images.length];  // Controlar el índice

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prevIndex) => (prevIndex + 1) % images.length);  // Iterar sobre las imágenes
    }, 3000);

    return () => clearInterval(interval);
  }, [images.length]);

  const handleDotClick = (index: number) => {
    setCurrentIndex(index);
  };

  return (
    <div className="relative flex flex-col items-center  bg-black mt-[100px]">
      <Circles value={titles[currentIndex]} image={imageSource} />
      <div className="relative flex flex-col items-center mt-72 w-full">
        <NavigationDots currentIndex={currentIndex} values={titles} handleDotClick={handleDotClick} />
        <div className="text-white mt-8 w-full text-[24px] h-auto text-center font-semibold">
          {titles[currentIndex]}
        </div>
        <ProgressBar progressBarWidth={progressBarWidth} />
      </div>
    </div>
  );
};

export default InteractiveComponent;





