import { useEffect, useState } from 'react'
import { BASE_URL } from '@/constants'

interface HeaderLinkProps {
  linkText: string
  linkUrl: string
  currentPath: string
}

const HeaderLink: React.FC<HeaderLinkProps> = ({
  linkText,
  linkUrl,
  currentPath,
}) => {
  const [urlInternet, setUrlInternet] = useState('')

  useEffect(() => {
    setUrlInternet(window.location.pathname)
  }, [])

  const normalizedLinkText = linkText.toLowerCase()
  const isInicio = urlInternet === '/' && normalizedLinkText === 'inicio'
  const isActive = isInicio || urlInternet === '/' + normalizedLinkText

  return (
    <a
      href={BASE_URL || '' + linkUrl}
      className={`max-w-44  text-white text-lg center rounded-full px-[16px] py-[10px] tracking-wider ${
        isActive ? 'bg-turquesa' : ''
      }`}
    >
      {linkText}
    </a>
  )
}

export default HeaderLink
