import MainCard from './MainCard'

interface MainCardsGridProps {
  cards: { title: string; info: string; icon: string }[]
}

const MainCardsGrid: React.FC<MainCardsGridProps> = ({ cards }) => {
  const groupedCards = []
  for (let i = 0; i < cards.length; i += 3) {
    groupedCards.push(cards.slice(i, i + 3))
  }

  return (
    <div className='mt-[10px] pr-[15px] pl-[10px] 2xl:mt-[150px] 2xl:mb-[150px] 2xl:pl-[155px] 2xl:pr-[155px] xl:pr-[155px] xl:pl-[155px]'>
      {groupedCards.map((group, groupIndex) => (
        <div
          key={groupIndex}
          className='flex flex-col items-center 2xl:flex-row 2xl:justify-between 2xl:items-center xl:flex-row xl:items-center'
        >
          {group.map((card, cardIndex) => (
            <div
              key={cardIndex}
              className={`w-full max-w-96 mt-11  2xl:mb-0 lg:w-1/3 ${
                cardIndex === 0 ? '' : '2xl:ml-[50px]'
              }`}
            >
              <MainCard
                title={card.title}
                info={card.info}
                icon={card.icon}
                shadowLevel={cardIndex}
              />
            </div>
          ))}
        </div>
      ))}
    </div>
  )
}

export default MainCardsGrid
