import { IMAGES_URL } from '@/constants';
import { useMediaQuery } from 'react-responsive';

interface MainCardProps {
  title: string;
  info: string;
  icon: string;
  shadowLevel: number;
}

const MainCard: React.FC<MainCardProps> = ({ title, info, icon, shadowLevel }) => {
  const averageLetterWidthDesktop = 17; 
  const averageLetterWidthMobile = 15; 

  const isDesktop = useMediaQuery({ query: '(min-width: 1023px)' });

  const titleWidth = isDesktop 
    ? title.length * averageLetterWidthDesktop 
    : title.length * averageLetterWidthMobile;

  const backGroundColor = [
    'bg-[#176F69]',
    'bg-[#166A64]',
    'bg-[#0D5D58]',
  ];

  const infoLines = info.split('\n');

  return (
    <div className={`p-6 ${backGroundColor[shadowLevel]} h-[361px] w-full rounded-bl-[20px] rounded-tr-[20px] 2xl:h-[480px] 2xl:w-[480px] 2xl:rounded-bl-[40px] 2xl:rounded-tr-[40px] xl:w-[310px] xl:h-[350px]`}>
      <img src={IMAGES_URL + icon} alt={title} className="mb-4 h-[75px] 2xl:h-[121px] object-contain" />
      <h3 className={`text-white text-[24px] md:text-[30px] mb-2 inline-block font-600 font-semibold`}>
        {title}
      </h3>
      <div 
        className="h-[4px] mb-4 bg-gradient-to-r from-azulGradiente to-verdeGradiente" 
        style={{ width: `${titleWidth}px` }}
      ></div>
      <ul className="text-white text-base font-light space-y-2">
        {infoLines.map((line, index) => (
          <li 
            key={index} 
            className="list-disc list-inside text-[20px] md:text-[28px] xl:text-[20px] 2xl:text-[28px] 2xl:leading-[42px]"
            style={{ textIndent: '-20px', paddingLeft: '20px' }}  // Aquí ajustamos el alineamiento
          >
            {line}
          </li>
        ))}
      </ul>
    </div>
  );
};

export default MainCard;
