import { useEffect } from 'react';

interface Props {
    titulo: string 
    texto: string
}
   

const AnimatedSection = ({ titulo, texto }) => {

    useEffect(() => {
        const sections = document.querySelectorAll('.fade-section');

        const observer = new IntersectionObserver(
            (entries) => {
                entries.forEach((entry) => {
                    if (entry.isIntersecting) {
                        entry.target.classList.remove('opacity-0');
                        entry.target.classList.add('opacity-100');
                    } else {
                        entry.target.classList.remove('opacity-100');
                        entry.target.classList.add('opacity-0');
                    }
                });
            },
            { threshold: 0.1 }
        );

        sections.forEach((section) => {
            observer.observe(section as Element);
        });

        return () => observer.disconnect();
    }, []);

    return (
        <div className='font-okta flex flex-col flex-1 space-y-[24px] items-center content-center px-[16px]                  
                        md:flex-row md:fade-section md:content-center md:space-x-[40px] md:px-[160px] md:mt-[160px] md:duration-1000 xl:flex-row md:fade-section xl:content-center xl:space-x-[30px] xl:pl-[160px] xl:pr-[160px] xl:mt-[120px] xl:mb-[100px] xl:duration-1000                            
        '>
            <h2 className="font-400 text-[100px] md:text-[190px] xl:text-[120px] 2xl:text-[160px] font-semibold">{titulo}</h2>
            <div className="bg-gradient-to-r from-azulGradiente from-0% to-verdeGradiente to-100% w-full h-[28px] 
            md:bg-gradient-to-t md:h-[198px] md:w-[20px] xl:h-[130px] 2xl:h-[191px]" />
            <p className='text-[20px] mb-[60px] font-extralight md:text-[37px] xl:text-[30px]'>{texto}</p>
        </div>
    );
};

export default AnimatedSection;
