import cpp from './cpp.mjs';
import python from './python.mjs';
import javascript from './javascript.mjs';
import r from './r.mjs';
import sql from './sql.mjs';
import './cpp-macro.mjs';
import './glsl.mjs';
import './c.mjs';

const lang = Object.freeze({ "displayName": "Julia", "name": "julia", "patterns": [{ "include": "#operator" }, { "include": "#array" }, { "include": "#string" }, { "include": "#parentheses" }, { "include": "#bracket" }, { "include": "#function_decl" }, { "include": "#function_call" }, { "include": "#for_block" }, { "include": "#keyword" }, { "include": "#number" }, { "include": "#comment" }, { "include": "#type_decl" }, { "include": "#symbol" }, { "include": "#punctuation" }], "repository": { "array": { "patterns": [{ "begin": "\\[", "beginCaptures": { "0": { "name": "meta.bracket.julia" } }, "end": "(\\])((?:\\.)?'*)", "endCaptures": { "1": { "name": "meta.bracket.julia" }, "2": { "name": "keyword.operator.transpose.julia" } }, "name": "meta.array.julia", "patterns": [{ "match": "\\bbegin\\b", "name": "constant.numeric.julia" }, { "match": "\\bend\\b", "name": "constant.numeric.julia" }, { "include": "#self_no_for_block" }] }] }, "bracket": { "patterns": [{ "begin": "\\{", "beginCaptures": { "0": { "name": "meta.bracket.julia" } }, "end": "(\\})((?:\\.)?'*)", "endCaptures": { "1": { "name": "meta.bracket.julia" }, "2": { "name": "keyword.operator.transpose.julia" } }, "patterns": [{ "include": "#self_no_for_block" }] }] }, "comment": { "patterns": [{ "include": "#comment_block" }, { "begin": "#", "beginCaptures": { "0": { "name": "punctuation.definition.comment.julia" } }, "end": "\\n", "name": "comment.line.number-sign.julia", "patterns": [{ "include": "#comment_tags" }] }] }, "comment_block": { "patterns": [{ "begin": "#=", "beginCaptures": { "0": { "name": "punctuation.definition.comment.begin.julia" } }, "end": "=#", "endCaptures": { "0": { "name": "punctuation.definition.comment.end.julia" } }, "name": "comment.block.number-sign-equals.julia", "patterns": [{ "include": "#comment_tags" }, { "include": "#comment_block" }] }] }, "comment_tags": { "patterns": [{ "match": "\\bTODO\\b", "name": "keyword.other.comment-annotation.julia" }, { "match": "\\bFIXME\\b", "name": "keyword.other.comment-annotation.julia" }, { "match": "\\bCHANGED\\b", "name": "keyword.other.comment-annotation.julia" }, { "match": "\\bXXX\\b", "name": "keyword.other.comment-annotation.julia" }] }, "for_block": { "comment": "for blocks need to be special-cased to support tokenizing 'outer' properly", "patterns": [{ "begin": "\\b(for)\\b", "beginCaptures": { "0": { "name": "keyword.control.julia" } }, "end": "(?<!,|\\s)(\\s*\\n)", "patterns": [{ "match": "\\bouter\\b", "name": "keyword.other.julia" }, { "include": "$self" }] }] }, "function_call": { "patterns": [{ "begin": "((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)({(?:[^{}]|{(?:[^{}]|{[^{}]*})*})*})?\\.?(\\()", "beginCaptures": { "1": { "name": "support.function.julia" }, "2": { "name": "support.type.julia" }, "3": { "name": "meta.bracket.julia" } }, "end": "\\)(('|(\\.'))*\\.?')?", "endCaptures": { "0": { "name": "meta.bracket.julia" }, "1": { "name": "keyword.operator.transposed-func.julia" } }, "patterns": [{ "include": "#self_no_for_block" }] }] }, "function_decl": { "patterns": [{ "captures": { "1": { "name": "entity.name.function.julia" }, "2": { "name": "support.type.julia" } }, "comment": "first group is function name\nSecond group is type parameters (e.g. {T<:Number, S})\nThen open parens\nThen a lookahead ensures that we are followed by:\n  - anything (function arguments)\n  - 0 or more spaces\n  - Finally an equal sign\nNegative lookahead ensures we don't have another equal sign (not `==`)", "match": "((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)({(?:[^{}]|{(?:[^{}]|{[^{}]*})*})*})?(?=\\([^#]*\\)(::[^\\s]+)?(\\s*\\bwhere\\b\\s+.+?)?\\s*?=(?![=>]))" }, { "captures": { "1": { "name": "keyword.other.julia" }, "2": { "name": "keyword.operator.dots.julia" }, "3": { "name": "entity.name.function.julia" }, "4": { "name": "support.type.julia" } }, "comment": "similar regex to previous, but with keyword not 1-line syntax", "match": "\\b(function|macro)(?:\\s+(?:(?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*(\\.))?((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)({(?:[^{}]|{(?:[^{}]|{[^{}]*})*})*})?|\\s*)(?=\\()" }] }, "keyword": { "patterns": [{ "match": "\\b(?<![:_\\.])(?:function|mutable\\s+struct|struct|macro|quote|abstract\\s+type|primitive\\s+type|module|baremodule|where)\\b", "name": "keyword.other.julia" }, { "match": "\\b(?<![:_])(?:if|else|elseif|for|while|begin|let|do|try|catch|finally|return|break|continue)\\b", "name": "keyword.control.julia" }, { "match": "\\b(?<![:_])end\\b", "name": "keyword.control.end.julia" }, { "match": "\\b(?<![:_])(?:global|local|const)\\b", "name": "keyword.storage.modifier.julia" }, { "match": "\\b(?<![:_])(?:export)\\b", "name": "keyword.control.export.julia" }, { "match": "^(?:public)\\b", "name": "keyword.control.public.julia" }, { "match": "\\b(?<![:_])(?:import)\\b", "name": "keyword.control.import.julia" }, { "match": "\\b(?<![:_])(?:using)\\b", "name": "keyword.control.using.julia" }, { "match": "(?<=\\w\\s)\\b(as)\\b(?=\\s\\w)", "name": "keyword.control.as.julia" }, { "match": "(@(\\.|(?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*))", "name": "support.function.macro.julia" }] }, "number": { "patterns": [{ "captures": { "1": { "name": "constant.numeric.julia" }, "2": { "name": "keyword.operator.conjugate-number.julia" } }, "match": "((?<!(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF]))(?:(?:\\b0(?:x|X)[0-9a-fA-F](?:_?[0-9a-fA-F])*)|(?:\\b0o[0-7](?:_?[0-7])*)|(?:\\b0b[0-1](?:_?[0-1])*)|(?:(?:\\b[0-9](?:_?[0-9])*\\.?(?!\\.)(?:[_0-9]*))|(?:\\b\\.[0-9](?:_?[0-9])*))(?:[efE][+-]?[0-9](?:_?[0-9])*)?(?:im\\b|Inf(?:16|32|64)?\\b|NaN(?:16|32|64)?\\b|\u03C0\\b|pi\\b|\u212F\\b)?|\\b[0-9]+|\\bInf(?:16|32|64)?\\b|\\bNaN(?:16|32|64)?\\b|\\b\u03C0\\b|\\bpi\\b|\\b\u212F\\b))('*)" }, { "match": "\\bARGS\\b|\\bC_NULL\\b|\\bDEPOT_PATH\\b|\\bENDIAN_BOM\\b|\\bENV\\b|\\bLOAD_PATH\\b|\\bPROGRAM_FILE\\b|\\bstdin\\b|\\bstdout\\b|\\bstderr\\b|\\bVERSION\\b|\\bdevnull\\b", "name": "constant.global.julia" }, { "match": "\\btrue\\b|\\bfalse\\b|\\bnothing\\b|\\bmissing\\b", "name": "constant.language.julia" }] }, "operator": { "patterns": [{ "match": "\\.?(?:<-->|->|-->|<--|\u2190|\u2192|\u2194|\u219A|\u219B|\u219E|\u21A0|\u21A2|\u21A3|\u21A6|\u21A4|\u21AE|\u21CE|\u21CD|\u21CF|\u21D0|\u21D2|\u21D4|\u21F4|\u21F6|\u21F7|\u21F8|\u21F9|\u21FA|\u21FB|\u21FC|\u21FD|\u21FE|\u21FF|\u27F5|\u27F6|\u27F7|\u27F9|\u27FA|\u27FB|\u27FC|\u27FD|\u27FE|\u27FF|\u2900|\u2901|\u2902|\u2903|\u2904|\u2905|\u2906|\u2907|\u290C|\u290D|\u290E|\u290F|\u2910|\u2911|\u2914|\u2915|\u2916|\u2917|\u2918|\u291D|\u291E|\u291F|\u2920|\u2944|\u2945|\u2946|\u2947|\u2948|\u294A|\u294B|\u294E|\u2950|\u2952|\u2953|\u2956|\u2957|\u295A|\u295B|\u295E|\u295F|\u2962|\u2964|\u2966|\u2967|\u2968|\u2969|\u296A|\u296B|\u296C|\u296D|\u2970|\u29F4|\u2B31|\u2B30|\u2B32|\u2B33|\u2B34|\u2B35|\u2B36|\u2B37|\u2B38|\u2B39|\u2B3A|\u2B3B|\u2B3C|\u2B3D|\u2B3E|\u2B3F|\u2B40|\u2B41|\u2B42|\u2B43|\u2977|\u2B44|\u297A|\u2B47|\u2B48|\u2B49|\u2B4A|\u2B4B|\u2B4C|\uFFE9|\uFFEB|\u21DC|\u21DD|\u219C|\u219D|\u21A9|\u21AA|\u21AB|\u21AC|\u21BC|\u21BD|\u21C0|\u21C1|\u21C4|\u21C6|\u21C7|\u21C9|\u21CB|\u21CC|\u21DA|\u21DB|\u21E0|\u21E2|\u21B7|\u21B6|\u21BA|\u21BB|=>)", "name": "keyword.operator.arrow.julia" }, { "match": "(?::=|\\+=|-=|\\*=|//=|/=|\\.//=|\\./=|\\.\\*=|\\\\=|\\.\\\\=|\\^=|\\.\\^=|%=|\\.%=|\xF7=|\\.\xF7=|\\|=|&=|\\.&=|\u22BB=|\\.\u22BB=|\\$=|<<=|>>=|>>>=|=(?!=))", "name": "keyword.operator.update.julia" }, { "match": "(?:<<|>>>|>>|\\.>>>|\\.>>|\\.<<)", "name": "keyword.operator.shift.julia" }, { "captures": { "1": { "name": "keyword.operator.relation.types.julia" }, "2": { "name": "support.type.julia" }, "3": { "name": "keyword.operator.transpose.julia" } }, "match": `(?:\\s*(::|>:|<:)\\s*((?:(?:Union)?\\([^)]*\\)|[[:alpha:]_$\u2207][[:word:]\u207A-\u209C!\u2032\\.]*(?:(?:{(?:[^{}]|{(?:[^{}]|{[^{}]*})*})*})|(?:".+?(?<!\\\\)"))?)))(?:\\.\\.\\.)?((?:\\.)?'*)` }, { "match": "(\\.?((?<!<)<=|(?<!>)>=|>|<|\u2265|\u2264|===|==|\u2261|!=|\u2260|!==|\u2262|\u2208|\u2209|\u220B|\u220C|\u2286|\u2288|\u2282|\u2284|\u228A|\u221D|\u220A|\u220D|\u2225|\u2226|\u2237|\u223A|\u223B|\u223D|\u223E|\u2241|\u2243|\u2242|\u2244|\u2245|\u2246|\u2247|\u2248|\u2249|\u224A|\u224B|\u224C|\u224D|\u224E|\u2250|\u2251|\u2252|\u2253|\u2256|\u2257|\u2258|\u2259|\u225A|\u225B|\u225C|\u225D|\u225E|\u225F|\u2263|\u2266|\u2267|\u2268|\u2269|\u226A|\u226B|\u226C|\u226D|\u226E|\u226F|\u2270|\u2271|\u2272|\u2273|\u2274|\u2275|\u2276|\u2277|\u2278|\u2279|\u227A|\u227B|\u227C|\u227D|\u227E|\u227F|\u2280|\u2281|\u2283|\u2285|\u2287|\u2289|\u228B|\u228F|\u2290|\u2291|\u2292|\u229C|\u22A9|\u22AC|\u22AE|\u22B0|\u22B1|\u22B2|\u22B3|\u22B4|\u22B5|\u22B6|\u22B7|\u22CD|\u22D0|\u22D1|\u22D5|\u22D6|\u22D7|\u22D8|\u22D9|\u22DA|\u22DB|\u22DC|\u22DD|\u22DE|\u22DF|\u22E0|\u22E1|\u22E2|\u22E3|\u22E4|\u22E5|\u22E6|\u22E7|\u22E8|\u22E9|\u22EA|\u22EB|\u22EC|\u22ED|\u22F2|\u22F3|\u22F4|\u22F5|\u22F6|\u22F7|\u22F8|\u22F9|\u22FA|\u22FB|\u22FC|\u22FD|\u22FE|\u22FF|\u27C8|\u27C9|\u27D2|\u29B7|\u29C0|\u29C1|\u29E1|\u29E3|\u29E4|\u29E5|\u2A66|\u2A67|\u2A6A|\u2A6B|\u2A6C|\u2A6D|\u2A6E|\u2A6F|\u2A70|\u2A71|\u2A72|\u2A73|\u2A75|\u2A76|\u2A77|\u2A78|\u2A79|\u2A7A|\u2A7B|\u2A7C|\u2A7D|\u2A7E|\u2A7F|\u2A80|\u2A81|\u2A82|\u2A83|\u2A84|\u2A85|\u2A86|\u2A87|\u2A88|\u2A89|\u2A8A|\u2A8B|\u2A8C|\u2A8D|\u2A8E|\u2A8F|\u2A90|\u2A91|\u2A92|\u2A93|\u2A94|\u2A95|\u2A96|\u2A97|\u2A98|\u2A99|\u2A9A|\u2A9B|\u2A9C|\u2A9D|\u2A9E|\u2A9F|\u2AA0|\u2AA1|\u2AA2|\u2AA3|\u2AA4|\u2AA5|\u2AA6|\u2AA7|\u2AA8|\u2AA9|\u2AAA|\u2AAB|\u2AAC|\u2AAD|\u2AAE|\u2AAF|\u2AB0|\u2AB1|\u2AB2|\u2AB3|\u2AB4|\u2AB5|\u2AB6|\u2AB7|\u2AB8|\u2AB9|\u2ABA|\u2ABB|\u2ABC|\u2ABD|\u2ABE|\u2ABF|\u2AC0|\u2AC1|\u2AC2|\u2AC3|\u2AC4|\u2AC5|\u2AC6|\u2AC7|\u2AC8|\u2AC9|\u2ACA|\u2ACB|\u2ACC|\u2ACD|\u2ACE|\u2ACF|\u2AD0|\u2AD1|\u2AD2|\u2AD3|\u2AD4|\u2AD5|\u2AD6|\u2AD7|\u2AD8|\u2AD9|\u2AF7|\u2AF8|\u2AF9|\u2AFA|\u22A2|\u22A3|\u27C2|\u2AEA|\u2AEB|<:|>:))", "name": "keyword.operator.relation.julia" }, { "match": "(?<=\\s)(?:\\?)(?=\\s)", "name": "keyword.operator.ternary.julia" }, { "match": "(?<=\\s)(?:\\:)(?=\\s)", "name": "keyword.operator.ternary.julia" }, { "match": "(?:\\|\\||&&|(?<!(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF]))!)", "name": "keyword.operator.boolean.julia" }, { "match": "(?<=[[:word:]\u207A-\u209C!\u2032\u2207\\)\\]\\}])(?::)", "name": "keyword.operator.range.julia" }, { "match": "(?:\\|>)", "name": "keyword.operator.applies.julia" }, { "match": "(?:\\||\\.\\||\\&|\\.\\&|~|\xAC|\\.~|\u22BB|\\.\u22BB)", "name": "keyword.operator.bitwise.julia" }, { "match": "\\.?(?:\\+\\+|\\-\\-|\\+|\\-|\u2212|\xA6|\\||\u2295|\u2296|\u229E|\u229F|\u222A|\u2228|\u2294|\xB1|\u2213|\u2214|\u2238|\u224F|\u228E|\u22BB|\u22BD|\u22CE|\u22D3|\u27C7|\u29FA|\u29FB|\u2A08|\u2A22|\u2A23|\u2A24|\u2A25|\u2A26|\u2A27|\u2A28|\u2A29|\u2A2A|\u2A2B|\u2A2C|\u2A2D|\u2A2E|\u2A39|\u2A3A|\u2A41|\u2A42|\u2A45|\u2A4A|\u2A4C|\u2A4F|\u2A50|\u2A52|\u2A54|\u2A56|\u2A57|\u2A5B|\u2A5D|\u2A61|\u2A62|\u2A63|\\*|//?|\u233F|\xF7|%|&|\xB7|\u0387|\u22C5|\u2218|\xD7|\\\\|\u2229|\u2227|\u2297|\u2298|\u2299|\u229A|\u229B|\u22A0|\u22A1|\u2293|\u2217|\u2219|\u2224|\u214B|\u2240|\u22BC|\u22C4|\u22C6|\u22C7|\u22C9|\u22CA|\u22CB|\u22CC|\u22CF|\u22D2|\u27D1|\u29B8|\u29BC|\u29BE|\u29BF|\u29F6|\u29F7|\u2A07|\u2A30|\u2A31|\u2A32|\u2A33|\u2A34|\u2A35|\u2A36|\u2A37|\u2A38|\u2A3B|\u2A3C|\u2A3D|\u2A40|\u2A43|\u2A44|\u2A4B|\u2A4D|\u2A4E|\u2A51|\u2A53|\u2A55|\u2A58|\u2A5A|\u2A5C|\u2A5E|\u2A5F|\u2A60|\u2ADB|\u228D|\u25B7|\u2A1D|\u27D5|\u27D6|\u27D7|\u2A1F|\\^|\u2191|\u2193|\u21F5|\u27F0|\u27F1|\u2908|\u2909|\u290A|\u290B|\u2912|\u2913|\u2949|\u294C|\u294D|\u294F|\u2951|\u2954|\u2955|\u2958|\u2959|\u295C|\u295D|\u2960|\u2961|\u2963|\u2965|\u296E|\u296F|\uFFEA|\uFFEC|\u221A|\u221B|\u221C|\u22C6|\xB1|\u2213)", "name": "keyword.operator.arithmetic.julia" }, { "match": "(?:\u2218)", "name": "keyword.operator.compose.julia" }, { "match": "(?:::|(?<=\\s)isa(?=\\s))", "name": "keyword.operator.isa.julia" }, { "match": "(?:(?<=\\s)in(?=\\s))", "name": "keyword.operator.relation.in.julia" }, { "match": "(?:\\.(?=(?:@|_|\\p{L}))|\\.\\.+|\u2026|\u205D|\u22EE|\u22F1|\u22F0|\u22EF)", "name": "keyword.operator.dots.julia" }, { "match": "(?:\\$)(?=.+)", "name": "keyword.operator.interpolation.julia" }, { "captures": { "2": { "name": "keyword.operator.transposed-variable.julia" } }, "match": "((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)(('|(\\.'))*\\.?')" }, { "captures": { "1": { "name": "bracket.end.julia" }, "2": { "name": "keyword.operator.transposed-matrix.julia" } }, "match": "(\\])((?:'|(?:\\.'))*\\.?')" }, { "captures": { "1": { "name": "bracket.end.julia" }, "2": { "name": "keyword.operator.transposed-parens.julia" } }, "match": "(\\))((?:'|(?:\\.'))*\\.?')" }] }, "parentheses": { "patterns": [{ "begin": "\\(", "beginCaptures": { "0": { "name": "meta.bracket.julia" } }, "end": "(\\))((?:\\.)?'*)", "endCaptures": { "1": { "name": "meta.bracket.julia" }, "2": { "name": "keyword.operator.transpose.julia" } }, "patterns": [{ "include": "#self_no_for_block" }] }] }, "punctuation": { "patterns": [{ "match": ",", "name": "punctuation.separator.comma.julia" }, { "match": ";", "name": "punctuation.separator.semicolon.julia" }] }, "self_no_for_block": { "comment": "Same as $self, but does not contain #for_block. 'outer' is not valid in some contexts (e.g. generators, comprehensions, indexing), so use this when matching those in begin/end patterns. Keep this up-to-date with $self!", "patterns": [{ "include": "#operator" }, { "include": "#array" }, { "include": "#string" }, { "include": "#parentheses" }, { "include": "#bracket" }, { "include": "#function_decl" }, { "include": "#function_call" }, { "include": "#keyword" }, { "include": "#number" }, { "include": "#comment" }, { "include": "#type_decl" }, { "include": "#symbol" }, { "include": "#punctuation" }] }, "string": { "patterns": [{ "begin": '(?:(@doc)\\s((?:doc)?""")|(doc"""))', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "end": '(""") ?(->)?', "endCaptures": { "1": { "name": "punctuation.definition.string.end.julia" }, "2": { "name": "keyword.operator.arrow.julia" } }, "name": "string.docstring.julia", "patterns": [{ "include": "#string_escaped_char" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": '(i?cxx)(""")', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "contentName": "meta.embedded.inline.cpp", "end": '"""', "endCaptures": { "0": { "name": "punctuation.definition.string.end.julia" } }, "name": "embed.cxx.julia", "patterns": [{ "include": "source.cpp#root_context" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": '(py)(""")', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "contentName": "meta.embedded.inline.python", "end": '([\\s\\w]*)(""")', "endCaptures": { "2": { "name": "punctuation.definition.string.end.julia" } }, "name": "embed.python.julia", "patterns": [{ "include": "source.python" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": '(js)(""")', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "contentName": "meta.embedded.inline.javascript", "end": '"""', "endCaptures": { "0": { "name": "punctuation.definition.string.end.julia" } }, "name": "embed.js.julia", "patterns": [{ "include": "source.js" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": '(R)(""")', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "contentName": "meta.embedded.inline.r", "end": '"""', "endCaptures": { "0": { "name": "punctuation.definition.string.end.julia" } }, "name": "embed.R.julia", "patterns": [{ "include": "source.r" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": '(raw)(""")', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "end": '"""', "endCaptures": { "0": { "name": "punctuation.definition.string.end.julia" } }, "name": "string.quoted.other.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": '(raw)(")', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "end": '"', "endCaptures": { "0": { "name": "punctuation.definition.string.end.julia" } }, "name": "string.quoted.other.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": '(sql)(""")', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "contentName": "meta.embedded.inline.sql", "end": '"""', "endCaptures": { "0": { "name": "punctuation.definition.string.end.julia" } }, "name": "embed.sql.julia", "patterns": [{ "include": "source.sql" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": 'var"""', "end": '"""', "name": "constant.other.symbol.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": 'var"', "end": '"', "name": "constant.other.symbol.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": '^\\s?(doc)?(""")\\s?$', "beginCaptures": { "1": { "name": "support.function.macro.julia" }, "2": { "name": "punctuation.definition.string.begin.julia" } }, "comment": "This only matches docstrings that start and end with triple quotes on\ntheir own line in the void", "end": '(""")', "endCaptures": { "1": { "name": "punctuation.definition.string.end.julia" } }, "name": "string.docstring.julia", "patterns": [{ "include": "#string_escaped_char" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": "'", "beginCaptures": { "0": { "name": "punctuation.definition.string.begin.julia" } }, "end": "'(?!')", "endCaptures": { "0": { "name": "punctuation.definition.string.end.julia" } }, "name": "string.quoted.single.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": '"""', "beginCaptures": { "0": { "name": "punctuation.definition.string.multiline.begin.julia" } }, "comment": "multi-line string with triple double quotes", "end": '"""', "endCaptures": { "0": { "name": "punctuation.definition.string.multiline.end.julia" } }, "name": "string.quoted.triple.double.julia", "patterns": [{ "include": "#string_escaped_char" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": '"(?!"")', "beginCaptures": { "0": { "name": "punctuation.definition.string.begin.julia" } }, "comment": "String with single pair of double quotes. Regex matches isolated double quote", "end": '"', "endCaptures": { "0": { "name": "punctuation.definition.string.end.julia" } }, "name": "string.quoted.double.julia", "patterns": [{ "include": "#string_escaped_char" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": 'r"""', "beginCaptures": { "0": { "name": "punctuation.definition.string.regexp.begin.julia" } }, "end": '(""")([imsx]{0,4})?', "endCaptures": { "1": { "name": "punctuation.definition.string.regexp.end.julia" }, "2": { "comment": "I took this scope name from python regex grammar", "name": "keyword.other.option-toggle.regexp.julia" } }, "name": "string.regexp.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": 'r"', "beginCaptures": { "0": { "name": "punctuation.definition.string.regexp.begin.julia" } }, "end": '(")([imsx]{0,4})?', "endCaptures": { "1": { "name": "punctuation.definition.string.regexp.end.julia" }, "2": { "comment": "I took this scope name from python regex grammar", "name": "keyword.other.option-toggle.regexp.julia" } }, "name": "string.regexp.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": '(?<!")((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)"""', "beginCaptures": { "0": { "name": "punctuation.definition.string.begin.julia" }, "1": { "name": "support.function.macro.julia" } }, "end": '(""")((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)?', "endCaptures": { "1": { "name": "punctuation.definition.string.end.julia" }, "2": { "name": "support.function.macro.julia" } }, "name": "string.quoted.other.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": '(?<!")((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)"', "beginCaptures": { "0": { "name": "punctuation.definition.string.begin.julia" }, "1": { "name": "support.function.macro.julia" } }, "end": '(?<![^\\\\]\\\\)(")((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)?', "endCaptures": { "1": { "name": "punctuation.definition.string.end.julia" }, "2": { "name": "support.function.macro.julia" } }, "name": "string.quoted.other.julia", "patterns": [{ "include": "#string_escaped_char" }] }, { "begin": "(?<!`)((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)?```", "beginCaptures": { "0": { "name": "punctuation.definition.string.begin.julia" }, "1": { "name": "support.function.macro.julia" } }, "end": "(```)((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)?", "endCaptures": { "1": { "name": "punctuation.definition.string.end.julia" }, "2": { "name": "support.function.macro.julia" } }, "name": "string.interpolated.backtick.julia", "patterns": [{ "include": "#string_escaped_char" }, { "include": "#string_dollar_sign_interpolate" }] }, { "begin": "(?<!`)((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)?`", "beginCaptures": { "0": { "name": "punctuation.definition.string.begin.julia" }, "1": { "name": "support.function.macro.julia" } }, "end": "(?<![^\\\\]\\\\)(`)((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)?", "endCaptures": { "1": { "name": "punctuation.definition.string.end.julia" }, "2": { "name": "support.function.macro.julia" } }, "name": "string.interpolated.backtick.julia", "patterns": [{ "include": "#string_escaped_char" }, { "include": "#string_dollar_sign_interpolate" }] }] }, "string_dollar_sign_interpolate": { "patterns": [{ "match": "\\$(?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF]|[^\\p{^Sc}$])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF]|[^\\p{^Sc}$])*", "name": "variable.interpolation.julia" }, { "begin": "\\$(\\()", "beginCaptures": { "1": { "name": "meta.bracket.julia" } }, "comment": "`punctuation.section.embedded`, `constant.escape`,\n& `meta.embedded.line` were considered but appear to have even spottier\nsupport among popular syntaxes.", "end": "\\)", "endCaptures": { "0": { "name": "meta.bracket.julia" } }, "name": "variable.interpolation.julia", "patterns": [{ "include": "#self_no_for_block" }] }] }, "string_escaped_char": { "patterns": [{ "match": "\\\\(\\\\|[0-3]\\d{,2}|[4-7]\\d?|x[a-fA-F0-9]{,2}|u[a-fA-F0-9]{,4}|U[a-fA-F0-9]{,8}|.)", "name": "constant.character.escape.julia" }] }, "symbol": { "patterns": [{ "comment": "This is string.quoted.symbol.julia in tpoisot's package", "match": '(?<![[:word:]\u207A-\u209C!\u2032\u2207\\)\\]\\}]):(?:(?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)(?!(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF]))(?!["`])', "name": "constant.other.symbol.julia" }] }, "type_decl": { "patterns": [{ "captures": { "1": { "name": "entity.name.type.julia" }, "2": { "name": "entity.other.inherited-class.julia" }, "3": { "name": "punctuation.separator.inheritance.julia" } }, "match": "(?>!:_)(?:struct|mutable\\s+struct|abstract\\s+type|primitive\\s+type)\\s+((?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*)(\\s*(<:)\\s*(?:[[:alpha:]_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{So}\u2190-\u21FF])(?:[[:word:]_!\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Sc}\u2140-\u2144\u223F\u22BE\u22BF\u22A4\u22A5\u2202\u2205-\u2207\u220E\u220F\u2210\u2211\u221E\u221F\u222B-\u2233\u22C0-\u22C3\u25F8-\u25FF\u266F\u27D8\u27D9\u27C0\u27C1\u29B0-\u29B4\u2A00-\u2A06\u2A09-\u2A16\u2A1B\u2A1C\u{1D6C1}\u{1D6DB}\u{1D6FB}\u{1D715}\u{1D735}\u{1D74F}\u{1D76F}\u{1D789}\u{1D7A9}\u{1D7C3}\u2071-\u207E\u2081-\u208E\u2220-\u2222\u299B-\u29AF\u2118\u212E\u309B-\u309C\u{1D7CE}-\u{1D7E1}]|[^\\P{Mn}-\xA1]|[^\\P{Mc}-\xA1]|[^\\P{Nd}-\xA1]|[^\\P{Pc}-\xA1]|[^\\P{Sk}-\xA1]|[^\\P{Me}-\xA1]|[^\\P{No}-\xA1]|[\u2032-\u2037\u2057]|[^\\P{So}\u2190-\u21FF])*(?:{.*})?)?", "name": "meta.type.julia" }] } }, "scopeName": "source.julia", "embeddedLangs": ["cpp", "python", "javascript", "r", "sql"], "aliases": ["jl"] });
var julia = [
  ...cpp,
  ...python,
  ...javascript,
  ...r,
  ...sql,
  lang
];

export { julia as default };
