import {visitChildren} from 'unist-util-visit-children'

// Patch the position on a parent node based on its first and last child.
export const patchPosition = visitChildren(function (child, index, node) {
  const siblings = node.children

  if (!child.position) {
    return
  }

  if (
    index < 1 &&
    /* c8 ignore next */
    (!node.position || !node.position.start)
  ) {
    patch(node)
    node.position.start = child.position.start
  }

  if (index === siblings.length - 1 && (!node.position || !node.position.end)) {
    patch(node)
    node.position.end = child.position.end
  }
})

// Add a `position` object when it does not yet exist on `node`.
function patch(node) {
  if (!node.position) {
    node.position = {}
  }
}
