import { AstroError } from "../core/errors/errors.js";
import { AstroJSX, jsx } from "../jsx-runtime/index.js";
import { renderJSX } from "../runtime/server/jsx.js";
const slotName = (str) => str.trim().replace(/[-_]([a-z])/g, (_, w) => w.toUpperCase());
async function check(Component, props, { default: children = null, ...slotted } = {}) {
  if (typeof Component !== "function") return false;
  const slots = {};
  for (const [key, value] of Object.entries(slotted)) {
    const name = slotName(key);
    slots[name] = value;
  }
  try {
    const result = await Component({ ...props, ...slots, children });
    return result[AstroJSX];
  } catch (e) {
    throwEnhancedErrorIfMdxComponent(e, Component);
  }
  return false;
}
async function renderToStaticMarkup(Component, props = {}, { default: children = null, ...slotted } = {}) {
  const slots = {};
  for (const [key, value] of Object.entries(slotted)) {
    const name = slotName(key);
    slots[name] = value;
  }
  const { result } = this;
  try {
    const html = await renderJSX(result, jsx(Component, { ...props, ...slots, children }));
    return { html };
  } catch (e) {
    throwEnhancedErrorIfMdxComponent(e, Component);
    throw e;
  }
}
function throwEnhancedErrorIfMdxComponent(error, Component) {
  if (Component[Symbol.for("mdx-component")]) {
    throw new AstroError({
      message: error.message,
      title: error.name,
      hint: `This issue often occurs when your MDX component encounters runtime errors.`,
      name: error.name,
      stack: error.stack
    });
  }
}
var server_default = {
  check,
  renderToStaticMarkup
};
export {
  check,
  server_default as default,
  renderToStaticMarkup
};
