import { basename, dirname, extname } from "node:path";
import { deterministicString } from "deterministic-object-hash";
import { removeQueryString } from "../../core/path.js";
import { shorthash } from "../../runtime/server/shorthash.js";
import { isESMImportedImage } from "./imageKind.js";
function propsToFilename(filePath, transform, hash) {
  let filename = decodeURIComponent(removeQueryString(filePath));
  const ext = extname(filename);
  filename = basename(filename, ext);
  const prefixDirname = isESMImportedImage(transform.src) ? dirname(filePath) : "";
  let outputExt = transform.format ? `.${transform.format}` : ext;
  return decodeURIComponent(`${prefixDirname}/${filename}_${hash}${outputExt}`);
}
function hashTransform(transform, imageService, propertiesToHash) {
  const hashFields = propertiesToHash.reduce(
    (acc, prop) => {
      acc[prop] = transform[prop];
      return acc;
    },
    { imageService }
  );
  return shorthash(deterministicString(hashFields));
}
export {
  hashTransform,
  propsToFilename
};
