import { Diagnostic, LanguagePlugin, LanguageServicePlugin } from '@volar/language-service';
import * as ts from 'typescript';
export declare function createTypeScriptChecker(languagePlugins: LanguagePlugin[], languageServicePlugins: LanguageServicePlugin[], tsconfig: string): {
    check: (fileName: string) => Promise<Diagnostic[]>;
    fixErrors: (fileName: string, diagnostics: Diagnostic[], only: string[] | undefined, writeFile: (fileName: string, newText: string) => Promise<void>) => Promise<void>;
    printErrors: (fileName: string, diagnostics: Diagnostic[], rootPath?: string) => string;
    language: import("@volar/language-service").Language;
    settings: {};
    fileCreated(fileName: string): void;
    fileUpdated(fileName: string): void;
    fileDeleted(fileName: string): void;
};
export declare function createTypeScriptInferredChecker(languagePlugins: LanguagePlugin[], languageServicePlugins: LanguageServicePlugin[], getScriptFileNames: () => string[], compilerOptions?: ts.CompilerOptions): {
    check: (fileName: string) => Promise<Diagnostic[]>;
    fixErrors: (fileName: string, diagnostics: Diagnostic[], only: string[] | undefined, writeFile: (fileName: string, newText: string) => Promise<void>) => Promise<void>;
    printErrors: (fileName: string, diagnostics: Diagnostic[], rootPath?: string) => string;
    language: import("@volar/language-service").Language;
    settings: {};
    fileCreated(fileName: string): void;
    fileUpdated(fileName: string): void;
    fileDeleted(fileName: string): void;
};
