import { h as ThemeInput, r as SpecialTheme, L as LanguageInput, q as SpecialLanguage, s as ThemeRegistrationAny, w as ThemeRegistrationResolved, K as LanguageRegistration, c as IGrammar, C as CodeToHastOptions, J as ResolveBundleKey, i as Root, j as CodeToTokensOptions, k as TokensResult, m as CodeToTokensBaseOptions, n as ThemedToken, o as CodeToTokensWithThemesOptions, p as ThemedTokenWithVariants } from './chunk-tokens.mjs';
export { G as AnsiLanguage, a8 as Awaitable, B as BundledHighlighterOptions, O as BundledLanguageInfo, a1 as BundledThemeInfo, Y as CodeOptionsMeta, V as CodeOptionsMultipleThemes, U as CodeOptionsSingleTheme, W as CodeOptionsThemes, X as CodeToHastOptionsCommon, y as CodeToHastRenderOptions, Z as CodeToHastRenderOptionsCommon, ad as DecorationItem, ac as DecorationOptions, af as DecorationTransformType, Q as DynamicImportLanguageRegistration, a0 as DynamicImportThemeRegistration, F as FontStyle, H as HighlighterCoreOptions, M as MaybeArray, a9 as MaybeGetter, aa as MaybeModule, ag as Offset, ah as OffsetOrPosition, P as PlainTextLanguage, v as Position, b as RawGrammar, a as RawTheme, g as RawThemeSetting, l as RequireKeys, ae as ResolvedDecorationItem, ai as ResolvedPosition, D as ShikiTransformer, a7 as ShikiTransformerContext, x as ShikiTransformerContextCommon, a6 as ShikiTransformerContextMeta, z as ShikiTransformerContextSource, ab as StringLiteralUnion, $ as ThemeRegistration, _ as ThemeRegistrationRaw, a3 as ThemedTokenExplanation, a2 as ThemedTokenScopeExplanation, a4 as TokenBase, u as TokenStyles, t as TokenizeWithThemeOptions, a5 as TransformerOptions } from './chunk-tokens.mjs';
export { W as WebAssemblyInstantiator } from './chunk-index.mjs';

/**
 * Internal context of Shiki, core textmate logic
 */
interface ShikiInternal<BundledLangKeys extends string = never, BundledThemeKeys extends string = never> {
    /**
     * Load a theme to the highlighter, so later it can be used synchronously.
     */
    loadTheme: (...themes: (ThemeInput | BundledThemeKeys | SpecialTheme)[]) => Promise<void>;
    /**
     * Load a language to the highlighter, so later it can be used synchronously.
     */
    loadLanguage: (...langs: (LanguageInput | BundledLangKeys | SpecialLanguage)[]) => Promise<void>;
    /**
     * Get the registered theme object
     */
    getTheme: (name: string | ThemeRegistrationAny) => ThemeRegistrationResolved;
    /**
     * Get the registered language object
     */
    getLanguage: (name: string | LanguageRegistration) => IGrammar;
    /**
     * Set the current theme and get the resolved theme object and color map.
     * @internal
     */
    setTheme: (themeName: string | ThemeRegistrationAny) => {
        theme: ThemeRegistrationResolved;
        colorMap: string[];
    };
    /**
     * Get the names of loaded languages
     *
     * Special-handled languages like `text`, `plain` and `ansi` are not included.
     */
    getLoadedLanguages: () => string[];
    /**
     * Get the names of loaded themes
     *
     * Special-handled themes like `none` are not included.
     */
    getLoadedThemes: () => string[];
}
/**
 * Generic instance interface of Shiki
 */
interface HighlighterGeneric<BundledLangKeys extends string, BundledThemeKeys extends string> extends ShikiInternal<BundledLangKeys, BundledThemeKeys> {
    /**
     * Get highlighted code in HTML string
     */
    codeToHtml: (code: string, options: CodeToHastOptions<ResolveBundleKey<BundledLangKeys>, ResolveBundleKey<BundledThemeKeys>>) => string;
    /**
     * Get highlighted code in HAST.
     * @see https://github.com/syntax-tree/hast
     */
    codeToHast: (code: string, options: CodeToHastOptions<ResolveBundleKey<BundledLangKeys>, ResolveBundleKey<BundledThemeKeys>>) => Root;
    /**
     * Get highlighted code in tokens. Uses `codeToTokensWithThemes` or `codeToTokensBase` based on the options.
     */
    codeToTokens: (code: string, options: CodeToTokensOptions<ResolveBundleKey<BundledLangKeys>, ResolveBundleKey<BundledThemeKeys>>) => TokensResult;
    /**
     * Get highlighted code in tokens with a single theme.
     * @returns A 2D array of tokens, first dimension is lines, second dimension is tokens in a line.
     */
    codeToTokensBase: (code: string, options: CodeToTokensBaseOptions<ResolveBundleKey<BundledLangKeys>, ResolveBundleKey<BundledThemeKeys>>) => ThemedToken[][];
    /**
     * Get highlighted code in tokens with multiple themes.
     *
     * Different from `codeToTokensBase`, each token will have a `variants` property consisting of an object of color name to token styles.
     *
     * @returns A 2D array of tokens, first dimension is lines, second dimension is tokens in a line.
     */
    codeToTokensWithThemes: (code: string, options: CodeToTokensWithThemesOptions<ResolveBundleKey<BundledLangKeys>, ResolveBundleKey<BundledThemeKeys>>) => ThemedTokenWithVariants[][];
    /**
     * Get internal context object
     * @internal
     * @deprecated
     */
    getInternalContext: () => ShikiInternal;
}
/**
 * The fine-grained core Shiki highlighter instance.
 */
type HighlighterCore = HighlighterGeneric<never, never>;

export { CodeToHastOptions, CodeToTokensBaseOptions, CodeToTokensOptions, CodeToTokensWithThemesOptions, IGrammar as Grammar, type HighlighterCore, type HighlighterGeneric, LanguageInput, LanguageRegistration, ResolveBundleKey, type ShikiInternal, SpecialLanguage, SpecialTheme, ThemeInput, ThemeRegistrationAny, ThemeRegistrationResolved, ThemedToken, ThemedTokenWithVariants, TokensResult };
