import { HighlighterCore, HighlighterGeneric, ShikiInternal } from './types.mjs';
import { H as HighlighterCoreOptions, B as BundledHighlighterOptions, L as LanguageInput, h as ThemeInput, C as CodeToHastOptions, i as Root, j as CodeToTokensOptions, k as TokensResult, l as RequireKeys, m as CodeToTokensBaseOptions, n as ThemedToken, o as CodeToTokensWithThemesOptions, p as ThemedTokenWithVariants, M as MaybeArray, P as PlainTextLanguage, q as SpecialLanguage, r as SpecialTheme, E as Element, s as ThemeRegistrationAny, t as TokenizeWithThemeOptions, u as TokenStyles, v as Position, c as IGrammar, w as ThemeRegistrationResolved, x as ShikiTransformerContextCommon, y as CodeToHastRenderOptions, z as ShikiTransformerContextSource, N as Nodes$1, A as RootContent$1, D as ShikiTransformer } from './chunk-tokens.mjs';
export { G as AnsiLanguage, a8 as Awaitable, O as BundledLanguageInfo, a1 as BundledThemeInfo, Y as CodeOptionsMeta, V as CodeOptionsMultipleThemes, U as CodeOptionsSingleTheme, W as CodeOptionsThemes, X as CodeToHastOptionsCommon, Z as CodeToHastRenderOptionsCommon, ad as DecorationItem, ac as DecorationOptions, af as DecorationTransformType, Q as DynamicImportLanguageRegistration, a0 as DynamicImportThemeRegistration, F as FontStyle, K as LanguageRegistration, a9 as MaybeGetter, aa as MaybeModule, ag as Offset, ah as OffsetOrPosition, b as RawGrammar, a as RawTheme, g as RawThemeSetting, J as ResolveBundleKey, ae as ResolvedDecorationItem, ai as ResolvedPosition, a7 as ShikiTransformerContext, a6 as ShikiTransformerContextMeta, ab as StringLiteralUnion, $ as ThemeRegistration, _ as ThemeRegistrationRaw, a3 as ThemedTokenExplanation, a2 as ThemedTokenScopeExplanation, a4 as TokenBase, a5 as TransformerOptions } from './chunk-tokens.mjs';
import { L as LoadWasmOptions } from './chunk-index.mjs';
export { W as WebAssemblyInstantiator, l as loadWasm } from './chunk-index.mjs';

/**
 * Create a Shiki core highlighter instance, with no languages or themes bundled.
 * Wasm and each language and theme must be loaded manually.
 *
 * @see http://shiki.style/guide/install#fine-grained-bundle
 */
declare function getHighlighterCore(options?: HighlighterCoreOptions): Promise<HighlighterCore>;

type GetHighlighterFactory<L extends string, T extends string> = (options: BundledHighlighterOptions<L, T>) => Promise<HighlighterGeneric<L, T>>;
/**
 * Create a `getHighlighter` function with bundled themes and languages.
 *
 * @param bundledLanguages
 * @param bundledThemes
 * @param loadWasm
 */
declare function createdBundledHighlighter<BundledLangs extends string, BundledThemes extends string>(bundledLanguages: Record<BundledLangs, LanguageInput>, bundledThemes: Record<BundledThemes, ThemeInput>, loadWasm: HighlighterCoreOptions['loadWasm']): GetHighlighterFactory<BundledLangs, BundledThemes>;
interface ShorthandsBundle<L extends string, T extends string> {
    /**
     * Shorthand for `codeToHtml` with auto-loaded theme and language.
     * A singleton highlighter it maintained internally.
     *
     * Differences from `highlighter.codeToHtml()`, this function is async.
     */
    codeToHtml: (code: string, options: CodeToHastOptions<L, T>) => Promise<string>;
    /**
     * Shorthand for `codeToHtml` with auto-loaded theme and language.
     * A singleton highlighter it maintained internally.
     *
     * Differences from `highlighter.codeToHtml()`, this function is async.
     */
    codeToHast: (code: string, options: CodeToHastOptions<L, T>) => Promise<Root>;
    /**
     * Shorthand for `codeToTokens` with auto-loaded theme and language.
     * A singleton highlighter it maintained internally.
     *
     * Differences from `highlighter.codeToTokens()`, this function is async.
     */
    codeToTokens: (code: string, options: CodeToTokensOptions<L, T>) => Promise<TokensResult>;
    /**
     * Shorthand for `codeToTokensBase` with auto-loaded theme and language.
     * A singleton highlighter it maintained internally.
     *
     * Differences from `highlighter.codeToTokensBase()`, this function is async.
     */
    codeToTokensBase: (code: string, options: RequireKeys<CodeToTokensBaseOptions<L, T>, 'theme' | 'lang'>) => Promise<ThemedToken[][]>;
    /**
     * Shorthand for `codeToTokensWithThemes` with auto-loaded theme and language.
     * A singleton highlighter it maintained internally.
     *
     * Differences from `highlighter.codeToTokensWithThemes()`, this function is async.
     */
    codeToTokensWithThemes: (code: string, options: RequireKeys<CodeToTokensWithThemesOptions<L, T>, 'themes' | 'lang'>) => Promise<ThemedTokenWithVariants[][]>;
    /**
     * Get internal singleton highlighter.
     *
     * @internal
     */
    getSingletonHighlighter: () => Promise<HighlighterGeneric<L, T>>;
}
declare function createSingletonShorthands<L extends string, T extends string>(getHighlighter: GetHighlighterFactory<L, T>): ShorthandsBundle<L, T>;

declare function toArray<T>(x: MaybeArray<T>): T[];
/**
 * Slipt a string into lines, each line preserves the line ending.
 */
declare function splitLines(code: string, preserveEnding?: boolean): [string, number][];
/**
 * Check if the language is plaintext that is ignored by Shiki.
 *
 * Hard-coded plain text languages: `plaintext`, `txt`, `text`, `plain`.
 */
declare function isPlainLang(lang: string | null | undefined): lang is PlainTextLanguage;
/**
 * Check if the language is specially handled or bypassed by Shiki.
 *
 * Hard-coded languages: `ansi` and plaintexts like `plaintext`, `txt`, `text`, `plain`.
 */
declare function isSpecialLang(lang: any): lang is SpecialLanguage;
/**
 * Check if the theme is specially handled or bypassed by Shiki.
 *
 * Hard-coded themes: `none`.
 */
declare function isNoneTheme(theme: string | ThemeInput | null | undefined): theme is 'none';
/**
 * Check if the theme is specially handled or bypassed by Shiki.
 *
 * Hard-coded themes: `none`.
 */
declare function isSpecialTheme(theme: string | ThemeInput | null | undefined): theme is SpecialTheme;
/**
 * Utility to append class to a hast node
 *
 * If the `property.class` is a string, it will be splitted by space and converted to an array.
 */
declare function addClassToHast(node: Element, className: string | string[]): Element;
/**
 * Split a token into multiple tokens by given offsets.
 *
 * The offsets are relative to the token, and should be sorted.
 */
declare function splitToken<T extends Pick<ThemedToken, 'content' | 'offset'>>(token: T, offsets: number[]): T[];
/**
 * Split 2D tokens array by given breakpoints.
 */
declare function splitTokens<T extends Pick<ThemedToken, 'content' | 'offset'>>(tokens: T[][], breakpoints: number[] | Set<number>): T[][];
declare function resolveColorReplacements(theme: ThemeRegistrationAny | string, options?: TokenizeWithThemeOptions): {
    [x: string]: string;
};
declare function applyColorReplacements(color: string, replacements?: Record<string, string>): string;
declare function applyColorReplacements(color?: string | undefined, replacements?: Record<string, string>): string | undefined;
declare function getTokenStyleObject(token: TokenStyles): Record<string, string>;
declare function stringifyTokenStyle(token: Record<string, string>): string;
/**
 * Creates a converter between index and position in a code block.
 */
declare function createPositionConverter(code: string): {
    lines: string[];
    indexToPos: (index: number) => Position;
    posToIndex: (line: number, character: number) => number;
};

/**
 * Set the default wasm loader for `loadWasm`.
 * @internal
 */
declare function setDefaultWasmLoader(_loader: LoadWasmOptions): void;
/**
 * Get the minimal shiki context for rendering.
 */
declare function getShikiInternal(options?: HighlighterCoreOptions): Promise<ShikiInternal>;

/**
 * Code to tokens, with a simple theme.
 */
declare function codeToTokensBase(internal: ShikiInternal, code: string, options?: CodeToTokensBaseOptions): ThemedToken[][];
declare function tokenizeWithTheme(code: string, grammar: IGrammar, theme: ThemeRegistrationResolved, colorMap: string[], options: TokenizeWithThemeOptions): ThemedToken[][];

/**
 * High-level code-to-tokens API.
 *
 * It will use `codeToTokensWithThemes` or `codeToTokensBase` based on the options.
 */
declare function codeToTokens(internal: ShikiInternal, code: string, options: CodeToTokensOptions): TokensResult;

declare function tokenizeAnsiWithTheme(theme: ThemeRegistrationResolved, fileContents: string, options?: TokenizeWithThemeOptions): ThemedToken[][];

declare function codeToHast(internal: ShikiInternal, code: string, options: CodeToHastOptions, transformerContext?: ShikiTransformerContextCommon): Root;
declare function tokensToHast(tokens: ThemedToken[][], options: CodeToHastRenderOptions, transformerContext: ShikiTransformerContextSource): Root;

type FormatSmartOptions = {
  /**
   * Prefer named character references (`&amp;`) where possible.
   */
  useNamedReferences?: boolean | undefined
  /**
   * Prefer the shortest possible reference, if that results in less bytes.
   * **Note**: `useNamedReferences` can be omitted when using `useShortestReferences`.
   */
  useShortestReferences?: boolean | undefined
  /**
   * Whether to omit semicolons when possible.
   * **Note**: This creates what HTML calls “parse errors” but is otherwise still valid HTML — don’t use this except when building a minifier.
   * Omitting semicolons is possible for certain named and numeric references in some cases.
   */
  omitOptionalSemicolons?: boolean | undefined
  /**
   * Create character references which don’t fail in attributes.
   * **Note**: `attribute` only applies when operating dangerously with
   * `omitOptionalSemicolons: true`.
   */
  attribute?: boolean | undefined
}

type CoreOptions = {
  /**
   * Whether to only escape the given subset of characters.
   */
  subset?: string[] | undefined
  /**
   * Whether to only escape possibly dangerous characters.
   * Those characters are `"`, `&`, `'`, `<`, `>`, and `` ` ``.
   */
  escapeOnly?: boolean | undefined
}

type Options$2 = CoreOptions &
  FormatSmartOptions

type Options$1 = Options$2

/**
 * Serialize hast as HTML.
 *
 * @param {Array<RootContent> | Nodes} tree
 *   Tree to serialize.
 * @param {Options | null | undefined} [options]
 *   Configuration (optional).
 * @returns {string}
 *   Serialized HTML.
 */
declare function toHtml(tree: Array<RootContent> | Nodes, options?: Options | null | undefined): string;
type Nodes = Nodes$1;
type RootContent = RootContent$1;
type StringifyEntitiesOptions = Options$1;
type CharacterReferences = Omit<StringifyEntitiesOptions, 'attribute' | 'escapeOnly' | 'subset'>;
/**
 * Configuration.
 */
type Options = {
    /**
     * Do not encode some characters which cause XSS vulnerabilities in older
     * browsers (default: `false`).
     *
     * > ⚠️ **Danger**: only set this if you completely trust the content.
     */
    allowDangerousCharacters?: boolean | null | undefined;
    /**
     * Allow `raw` nodes and insert them as raw HTML (default: `false`).
     *
     * When `false`, `Raw` nodes are encoded.
     *
     * > ⚠️ **Danger**: only set this if you completely trust the content.
     */
    allowDangerousHtml?: boolean | null | undefined;
    /**
     * Do not encode characters which cause parse errors (even though they work),
     * to save bytes (default: `false`).
     *
     * Not used in the SVG space.
     *
     * > 👉 **Note**: intentionally creates parse errors in markup (how parse
     * > errors are handled is well defined, so this works but isn’t pretty).
     */
    allowParseErrors?: boolean | null | undefined;
    /**
     * Use “bogus comments” instead of comments to save byes: `<?charlie>`
     * instead of `<!--charlie-->` (default: `false`).
     *
     * > 👉 **Note**: intentionally creates parse errors in markup (how parse
     * > errors are handled is well defined, so this works but isn’t pretty).
     */
    bogusComments?: boolean | null | undefined;
    /**
     * Configure how to serialize character references (optional).
     */
    characterReferences?: CharacterReferences | null | undefined;
    /**
     * Close SVG elements without any content with slash (`/`) on the opening tag
     * instead of an end tag: `<circle />` instead of `<circle></circle>`
     * (default: `false`).
     *
     * See `tightSelfClosing` to control whether a space is used before the
     * slash.
     *
     * Not used in the HTML space.
     */
    closeEmptyElements?: boolean | null | undefined;
    /**
     * Close self-closing nodes with an extra slash (`/`): `<img />` instead of
     * `<img>` (default: `false`).
     *
     * See `tightSelfClosing` to control whether a space is used before the
     * slash.
     *
     * Not used in the SVG space.
     */
    closeSelfClosing?: boolean | null | undefined;
    /**
     * Collapse empty attributes: get `class` instead of `class=""` (default:
     * `false`).
     *
     * Not used in the SVG space.
     *
     * > 👉 **Note**: boolean attributes (such as `hidden`) are always collapsed.
     */
    collapseEmptyAttributes?: boolean | null | undefined;
    /**
     * Omit optional opening and closing tags (default: `false`).
     *
     * For example, in `<ol><li>one</li><li>two</li></ol>`, both `</li>` closing
     * tags can be omitted.
     * The first because it’s followed by another `li`, the last because it’s
     * followed by nothing.
     *
     * Not used in the SVG space.
     */
    omitOptionalTags?: boolean | null | undefined;
    /**
     * Leave attributes unquoted if that results in less bytes (default: `false`).
     *
     * Not used in the SVG space.
     */
    preferUnquoted?: boolean | null | undefined;
    /**
     * Preferred quote to use (default: `'"'`).
     */
    quote?: Quote | null | undefined;
    /**
     * Use the other quote if that results in less bytes (default: `false`).
     */
    quoteSmart?: boolean | null | undefined;
    /**
     * When an `<svg>` element is found in the HTML space, this package already
     * automatically switches to and from the SVG space when entering and exiting
     * it (default: `'html'`).
     *
     * > 👉 **Note**: hast is not XML.
     * > It supports SVG as embedded in HTML.
     * > It does not support the features available in XML.
     * > Passing SVG might break but fragments of modern SVG should be fine.
     * > Use [`xast`][xast] if you need to support SVG as XML.
     */
    space?: Space | null | undefined;
    /**
     * Join attributes together, without whitespace, if possible: get
     * `class="a b"title="c d"` instead of `class="a b" title="c d"` to save
     * bytes (default: `false`).
     *
     * Not used in the SVG space.
     *
     * > 👉 **Note**: intentionally creates parse errors in markup (how parse
     * > errors are handled is well defined, so this works but isn’t pretty).
     */
    tightAttributes?: boolean | null | undefined;
    /**
     * Join known comma-separated attribute values with just a comma (`,`),
     * instead of padding them on the right as well (`,␠`, where `␠` represents a
     * space) (default: `false`).
     */
    tightCommaSeparatedLists?: boolean | null | undefined;
    /**
     * Drop unneeded spaces in doctypes: `<!doctypehtml>` instead of
     * `<!doctype html>` to save bytes (default: `false`).
     *
     * > 👉 **Note**: intentionally creates parse errors in markup (how parse
     * > errors are handled is well defined, so this works but isn’t pretty).
     */
    tightDoctype?: boolean | null | undefined;
    /**
     * Do not use an extra space when closing self-closing elements: `<img/>`
     * instead of `<img />` (default: `false`).
     *
     * > 👉 **Note**: only used if `closeSelfClosing: true` or
     * > `closeEmptyElements: true`.
     */
    tightSelfClosing?: boolean | null | undefined;
    /**
     * Use a `<!DOCTYPE…` instead of `<!doctype…` (default: `false`).
     *
     * Useless except for XHTML.
     */
    upperDoctype?: boolean | null | undefined;
    /**
     * Tag names of elements to serialize without closing tag (default: `html-void-elements`).
     *
     * Not used in the SVG space.
     *
     * > 👉 **Note**: It’s highly unlikely that you want to pass this, because
     * > hast is not for XML, and HTML will not add more void elements.
     */
    voids?: ReadonlyArray<string> | null | undefined;
};
/**
 * HTML quotes for attribute values.
 */
type Quote = '"' | "'";
/**
 * Namespace.
 */
type Space = 'html' | 'svg';

/**
 * Get highlighted code in HTML.
 */
declare function codeToHtml(internal: ShikiInternal, code: string, options: CodeToHastOptions): string;

/**
 * Get tokens with multiple themes
 */
declare function codeToTokensWithThemes(internal: ShikiInternal, code: string, options: CodeToTokensWithThemesOptions): ThemedTokenWithVariants[][];

/**
 * Normalize a textmate theme to shiki theme
 */
declare function normalizeTheme(rawTheme: ThemeRegistrationAny): ThemeRegistrationResolved;

/**
 * A built-in transformer to add decorations to the highlighted code.
 */
declare function transformerDecorations(): ShikiTransformer;

declare class ShikiError extends Error {
    constructor(message: string);
}

export { BundledHighlighterOptions, CodeToHastOptions, CodeToHastRenderOptions, CodeToTokensBaseOptions, CodeToTokensOptions, CodeToTokensWithThemesOptions, type GetHighlighterFactory, IGrammar as Grammar, HighlighterCore, HighlighterCoreOptions, HighlighterGeneric, LanguageInput, MaybeArray, PlainTextLanguage, Position, RequireKeys, ShikiError, ShikiInternal, ShikiTransformer, ShikiTransformerContextCommon, ShikiTransformerContextSource, type ShorthandsBundle, SpecialLanguage, SpecialTheme, ThemeInput, ThemeRegistrationAny, ThemeRegistrationResolved, ThemedToken, ThemedTokenWithVariants, TokenStyles, TokenizeWithThemeOptions, TokensResult, addClassToHast, applyColorReplacements, codeToHast, codeToHtml, codeToTokens, codeToTokensBase, codeToTokensWithThemes, createPositionConverter, createSingletonShorthands, createdBundledHighlighter, getHighlighterCore, getShikiInternal, getTokenStyleObject, toHtml as hastToHtml, isNoneTheme, isPlainLang, isSpecialLang, isSpecialTheme, normalizeTheme, resolveColorReplacements, setDefaultWasmLoader, splitLines, splitToken, splitTokens, stringifyTokenStyle, toArray, tokenizeAnsiWithTheme, tokenizeWithTheme, tokensToHast, transformerDecorations };
