import type { Root } from 'hast';
type Highlighter = (code: string, language: string, options?: {
    meta?: string;
}) => Promise<string>;
/**
 * A hast utility to syntax highlight code blocks with a given syntax highlighter.
 *
 * @param tree
 *   The hast tree in which to syntax highlight code blocks.
 * @param highlighter
 *   A fnction which receives the code and language, and returns the HTML of a syntax
 *   highlighted `<pre>` element.
 */
export declare function highlightCodeBlocks(tree: Root, highlighter: Highlighter): Promise<void>;
export {};
