"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const node_1 = require("@volar/language-server/node");
const languageServerPlugin_js_1 = require("./languageServerPlugin.js");
const connection = (0, node_1.createConnection)();
const server = (0, node_1.createServer)(connection);
connection.listen();
connection.onInitialize((params) => {
    const tsdk = params.initializationOptions?.typescript?.tsdk;
    if (!tsdk) {
        throw new Error('The `typescript.tsdk` init option is required. It should point to a directory containing a `typescript.js` or `tsserverlibrary.js` file, such as `node_modules/typescript/lib`.');
    }
    const { typescript, diagnosticMessages } = (0, node_1.loadTsdkByPath)(tsdk, params.locale);
    return server.initialize(params, (0, languageServerPlugin_js_1.getLanguageServicePlugins)(connection, typescript), (0, node_1.createTypeScriptProjectProvider)(typescript, diagnosticMessages, (env, project) => (0, languageServerPlugin_js_1.getLanguagePlugins)(connection, typescript, env, project.configFileName)));
});
connection.onInitialized(() => {
    server.initialized();
    server.watchFiles([
        `**/*.{${[
            'js',
            'cjs',
            'mjs',
            'ts',
            'cts',
            'mts',
            'jsx',
            'tsx',
            'json',
            'astro',
            'vue',
            'svelte',
        ].join(',')}}`,
    ]);
});
//# sourceMappingURL=nodeServer.js.map