"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVueLanguageModule = void 0;
const language_core_1 = require("@volar/language-core");
const vscode_uri_1 = require("vscode-uri");
const utils_js_1 = require("./utils.js");
function getVueLanguageModule() {
    return {
        getLanguageId(scriptId) {
            if (scriptId.endsWith('.vue')) {
                return 'vue';
            }
        },
        createVirtualCode(scriptId, languageId, snapshot) {
            if (languageId === 'vue') {
                const fileName = scriptId.includes('://')
                    ? vscode_uri_1.URI.parse(scriptId).fsPath.replace(/\\/g, '/')
                    : scriptId;
                return new VueVirtualCode(fileName, snapshot);
            }
        },
        updateVirtualCode(_scriptId, vueCode, snapshot) {
            vueCode.update(snapshot);
            return vueCode;
        },
        typescript: {
            extraFileExtensions: [{ extension: 'vue', isMixedContent: true, scriptKind: 7 }],
            getServiceScript(vueCode) {
                for (const code of (0, language_core_1.forEachEmbeddedCode)(vueCode)) {
                    if (code.id === 'tsx') {
                        return {
                            code,
                            extension: '.tsx',
                            scriptKind: 4,
                        };
                    }
                }
            },
        },
    };
}
exports.getVueLanguageModule = getVueLanguageModule;
class VueVirtualCode {
    constructor(fileName, snapshot) {
        this.fileName = fileName;
        this.snapshot = snapshot;
        this.id = 'root';
        this.languageId = 'vue';
        this.codegenStacks = [];
        this.onSnapshotUpdated();
    }
    update(newSnapshot) {
        this.snapshot = newSnapshot;
        this.onSnapshotUpdated();
    }
    onSnapshotUpdated() {
        this.mappings = [];
        this.embeddedCodes = [];
        this.embeddedCodes.push((0, utils_js_1.framework2tsx)(this.fileName, this.snapshot.getText(0, this.snapshot.getLength()), 'vue'));
    }
}
//# sourceMappingURL=vue.js.map