# @astrojs/language-server

The Astro language server, implement the [language server protocol](https://microsoft.github.io/language-server-protocol/)

## Folder structure

```plaintext
├── bin             # .js file used to start the server
├── dist            # Compiled files, generated by TypeScript
├── src             # Source files
│   ├── core        # Core code such as .astro file parsing, configuration manager, document definition etc
│   └── plugins     # Modules for the different languages supported in .astro files
├── test            # Tests
└── types           # Types injected into Astro files by the language server under certain conditions
```

## Troubleshooting

### Formatting does not work

> Using VS Code? This section does not apply to you, the VS Code extension includes both Prettier and the Astro plugin by default.

The Astro language server uses Prettier to format Astro files, but does not include `prettier` or `prettier-plugin-astro` by itself as dependencies in order to keep the dependency count low and allow users to better control the version of Prettier they want to use.

As such, if you want to use formatting, you'll need to install `prettier` and `prettier-plugin-astro` as dependencies in your project.
